uniform mat4 uniform_mtx4_wvp;
uniform vec3 uniform_vec3_depth;
uniform vec4 uniform_vec4_lightcolour;
uniform vec3 uniform_vec3_lightdir;

attribute vec3 attrib_position;
attribute vec4 attrib_colour;
attribute vec2 attrib_uv;

varying vec4 v_colour;
varying vec2 v_screenpos;
varying vec3 v_lightdir;
varying vec2 v_uv;

void main()
{
    vec3 pos = vec3(attrib_position.xy,1.0);
    vec4 outPos = uniform_mtx4_wvp * vec4(pos.xy,uniform_vec3_depth.x,1.0);
    
    gl_Position = outPos;
	v_colour    = attrib_colour*uniform_vec4_lightcolour;
    
    // From the RGB, calculate the V in HSV           
    v_colour.a  = max(uniform_vec4_lightcolour.r, max(uniform_vec4_lightcolour.g, uniform_vec4_lightcolour.b));
           
    v_screenpos   = (outPos.xy+1.0)*0.5;
    v_screenpos.y = v_screenpos.y;
    v_lightdir    = uniform_vec3_lightdir;
    v_uv          = attrib_uv;
}

